<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/GeneratoreUrl.php";
    
    session_start();
    
    //viene creatar quì una variabile data che poi viene usata da tutte le query che la richiedono
    $data = date("Y-m-d");
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $impostazioni  = recuperaImpostazioni($geecomDb);
    $datiGeecomCms = $geecomDb->leggiSingolaRiga("geec_prodotti",1);
    $cartellaAmministrazione = str_replace("../","",$datiGeecomCms["percorso"]);
            
    // vengono inizializzati gli array contenenti tutte le query di creazione e inizializzazione tabelle, che poi verranno passate al dbManager che le eseguirà in blocco
    $queryCreazioniTabelle      = [];
    $queryConfigurazioneTabelle = [];

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_prodotti` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `codiceProdotto` VARCHAR(255) NOT NULL,
        `idFornitore` int(11) NOT NULL,
        `lingua` VARCHAR(55) NOT NULL,
        `prodottoRiferimento` int(11) NOT NULL,
        `prodottoPadre` int(11) NOT NULL,
        `ean` VARCHAR(55) NOT NULL,
        `nome` VARCHAR(255) NOT NULL,
        `alias` VARCHAR(255) NOT NULL,
        `immagine` VARCHAR(255) NOT NULL,
        `template` VARCHAR(255) NOT NULL,
        `pubblicato` VARCHAR(255) NOT NULL,
        `usaVariazioni` VARCHAR(55) NOT NULL,
        `categoria` int(11) NOT NULL,
        `disponibilita` mediumint(9) NOT NULL,
        `prodottoInesauribile` VARCHAR (55) NOT NULL,
        `prezzo` DOUBLE(8,2) NOT NULL,
        `prezzoOfferta` DOUBLE(8,2) NOT NULL,
        `iva` TINYINT(4) NOT NULL,
        `prezzoAcquisto` DOUBLE(8,2) NOT NULL,
        `prezzoUnitario` DOUBLE(8,2) NOT NULL,
        `unita` VARCHAR(255) NOT NULL,
        `minimoAcquisto` SMALLINT(6) NOT NULL,
        `metaDescrizione` text NOT NULL,
        `descrizione` text NOT NULL,
        `testoDettagli` text NOT NULL,
        `marca` VARCHAR(255) NOT NULL,
        `modello` VARCHAR(255) NOT NULL,
        `formato` VARCHAR(255) NOT NULL,
        `materiale` VARCHAR(255) NOT NULL,
        `capacità` VARCHAR(255) NOT NULL,
        `colore` VARCHAR(255) NOT NULL,
        `larghezza` mediumint(9) NOT NULL,
        `altezza` mediumint(9) NOT NULL,
        `profondità` mediumint(9) NOT NULL,
        `peso` DOUBLE(8,2) NOT NULL,
        `pesoVolumetrico` DOUBLE(8,2) NOT NULL,
        `acquistoOpzioneObbligatorio` VARCHAR(255) DEFAULT 'no',
        `tipoProdotto` VARCHAR(255) NOT NULL,
        `numeroVisite` int(11) NOT NULL,
        `numeroVendite` int(11) NOT NULL,
        `abilitaCommenti` VARCHAR(255) NOT NULL,
        `dataInserimento` date NOT NULL,
        PRIMARY KEY ( `id` )
      ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle opzioni di acquisto
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_attributiProdotto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idProdotto` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `valori` VARCHAR( 255 ) NOT NULL ,
        `costi` VARCHAR( 255 ) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
     //query per creare la tabella delle variazioni di prodotto
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_variazioniProdotto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `codiceProdotto` VARCHAR( 255 ) NOT NULL ,
        `idProdotto` INT( 11 ) NOT NULL,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `costo` DOUBLE( 8,2 ) NOT NULL ,
        `quantita` MEDIUMINT NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella delle opzioni di acquisto
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_opzioniAcquisto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR( 255 ) NOT NULL ,
        `alias` VARCHAR( 255 ) NOT NULL ,
        `immagine` VARCHAR( 255 ) NOT NULL ,
        `pubblicato` VARCHAR( 255 ) NOT NULL ,
        `categoria` INT( 11 ) NOT NULL ,
        `prezzo` DOUBLE(8,2) NOT NULL,
        `descrizione` TEXT( 65000 ) NOT NULL,
        `dataInserimento` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella degli ordini
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_ordini` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idCliente` INT( 11 ) NOT NULL,
        `idCarrello` INT( 11 ) NOT NULL,
        `codiceSconto` VARCHAR (255) NOT NULL,
        `stato` VARCHAR(255) NOT NULL,
        `idTransazione` VARCHAR(255) NOT NULL,
        `destinatario` VARCHAR(255) NOT NULL,
        `indirizzoSpedizione` VARCHAR(255) NOT NULL ,
        `citta` VARCHAR(255) NOT NULL ,
        `capSpedizione` VARCHAR(255) NOT NULL ,
        `codiceTracciamento` VARCHAR(255) NOT NULL,
        `email` VARCHAR(255) NOT NULL,
        `telefono` VARCHAR(255) NOT NULL,
        `tipoSpedizione` VARCHAR(255) NOT NULL,
        `tipoPagamento` VARCHAR(255) NOT NULL,
        `codiceFiscale` VARCHAR(255) NOT NULL,
        `partitaIva` VARCHAR(255) NOT NULL,
        `tipoRicevuta` VARCHAR(255) NOT NULL,
        `importoTotaleOrdine` DOUBLE(8,2) NOT NULL ,
        `dataOrdine` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella degli ordini
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_abbonamenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idCliente` INT( 11 ) NOT NULL,
        `idProdotto` INT( 11 ) NOT NULL,
        `attributo` VARCHAR(255) NOT NULL,
        `stato` VARCHAR(255) NOT NULL,
        `ultimaTransazione` VARCHAR(255) NOT NULL,
        `destinatario` VARCHAR(255) NOT NULL,
        `indirizzoSpedizione` VARCHAR(255) NOT NULL ,
        `citta` VARCHAR(255) NOT NULL ,
        `capSpedizione` VARCHAR(255) NOT NULL ,
        `email` VARCHAR(255) NOT NULL,
        `telefono` VARCHAR(255) NOT NULL,
        `tipoSpedizione` VARCHAR(255) NOT NULL,
        `tipoPagamento` VARCHAR(255) NOT NULL,
        `tipoRicevuta` VARCHAR(255) NOT NULL,
        `importoTotaleOrdine` DOUBLE(8,2) NOT NULL ,
        `dataUltimoRinnovo` DATETIME NOT NULL ,
        `dataScadenza` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //imposta il valore iniziale dell'id a 1000
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "ALTER TABLE `geecEc_ordini` AUTO_INCREMENT=1000;";

    //query per creare la tabella dei carrelli, dove vengono memorizzati i dati
    //mentre l'utente sta effettuando l'acquisto. Al momento del pagamento i prodotti
    //nel carrello verranno messi in una tabella ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_carrelli` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idCliente` INT( 11 ) NOT NULL,
        `idSpedizione` INT( 11 ) NOT NULL,
        `importoProdotti` DOUBLE (8,2) NOT NULL ,
        `ivaProdotti` DOUBLE (8,2) NOT NULL ,
        `importoSpedizione` DOUBLE (8,2) NOT NULL ,
        `buonoSconto` VARCHAR (255) NOT NULL ,
        `valoreBuonoSconto` DOUBLE (8,2) NOT NULL ,
        `importoTotale` DOUBLE (8,2) NOT NULL ,
        `nome` VARCHAR(255) NOT NULL ,
        `cognome` VARCHAR(255) NOT NULL ,
        `nazione` VARCHAR(255) NOT NULL ,
        `citta` VARCHAR(255) NOT NULL ,
        `indirizzo` VARCHAR(255) NOT NULL ,
        `capSpedizione` VARCHAR(255) NOT NULL ,
        `email` VARCHAR(255) NOT NULL,
        `telefono` VARCHAR(255) NOT NULL,
        `codiceFiscale` VARCHAR(255) NOT NULL,
        `partitaIva` VARCHAR(255) NOT NULL,
        `dataCreazione` DATETIME NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella dei coupon
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_buoniSconto` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL,
        `codice` VARCHAR(255) NOT NULL,
        `tipo` VARCHAR(255) NOT NULL,
        `ammontareSconto` DOUBLE(9,2) NOT NULL,
        `prodottiInteressati` VARCHAR(255) NOT NULL,
        `prodotto` INT(11) NOT NULL,
        `categoria` INT(11) NOT NULL,
        `spesaMinima` DOUBLE(8,2) NOT NULL,
        `limitePerPersona` INT(11) NOT NULL,
        `buoniRimanenti` INT(11) NOT NULL,
        `dataCreazione` DATE NOT NULL,
        `dataScadenza` DATE NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella dei metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_metodiSpedizione` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL ,
        `disponibile` VARCHAR(255) NOT NULL ,
        `categoria` VARCHAR(255) NOT NULL ,
        `descrizione` VARCHAR(255) NOT NULL ,
        `giorniNecessari` SMALLINT (6) NOT NULL,
        `giorniInCuiSiSpedisce` VARCHAR(255) NOT NULL ,
        `orarioLimite` TIME NOT NULL ,
        `costo` DOUBLE(9,2) NOT NULL ,
        `costoZoneDisagiate` DOUBLE(9,2) NOT NULL ,
        `importoMinimoCarrello` DOUBLE(9,2) NOT NULL ,
        `areaGeografica` INT(11) NOT NULL,
        `dataCreazione` DATE NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per modificare la tabella dei metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_fascePrezzoSpedizione` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `idSpedizione` INT( 11 ) NOT NULL,
        `pesoMinimo` SMALLINT( 6 ) NOT NULL,
        `pesoMassimo` SMALLINT( 6 ) NOT NULL,
        `costo` DOUBLE(9,2) NOT NULL ,
        `costoZoneDisagiate` DOUBLE(9,2) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella delle zone disagiate per i metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_zoneDisagiate` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL ,
        `capInizio` VARCHAR (255) NOT NULL ,
        `capFine` VARCHAR (255) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
     //query per creare la tabella delle aree geografiche per i metodi di spedizione
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_areeGeografiche` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL ,
        `nazioni` TEXT (2500) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //query per creare la tabella dei prodotti ordinati, ovvero dei singoli prodotti che sono stati acquistati
    //in un ordine
    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_prodottiOrdinati` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `tipo` VARCHAR (255) NOT NULL,
        `idCarrello` INT( 11 ) NOT NULL,
        `idProdotto` INT( 11 ) NOT NULL,
        `idVariazione` INT NOT NULL,
        `quantita` MEDIUMINT NOT NULL,
        `nomeProdotto` VARCHAR (255) NOT NULL,
        `attributo` VARCHAR (255) NOT NULL,
        `prezzoUnitario` DOUBLE(8,2)  NOT NULL ,
        `ivaProdottoUnitario` DOUBLE(8,2)  NOT NULL ,
        `importoTotale` DOUBLE(8,2) NOT NULL ,
        `prezzoUnitarioOpzione` DOUBLE(8,2) NOT NULL ,
        `importoTotaleOpzione` DOUBLE(8,2) NOT NULL ,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle impostazioni base
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_impostazioni` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `abilitaRitiroInSede` VARCHAR(255) NOT NULL ,
        `abilitaSpedizioneGratuita` VARCHAR(255) NOT NULL ,
        `importoMinimo` INT(9) NOT NULL ,
        `nascondiDivSpedizione` VARCHAR(255) NOT NULL ,
        `linkCondizioniAcquisto` VARCHAR(255) NOT NULL ,
        `posizioneBarraLaterale` VARCHAR(255) NOT NULL ,
        `bloccaAcquisti` VARCHAR(255) NOT NULL ,
        `mailOrdini` VARCHAR(255) NOT NULL ,
        `registrazioneObbligatoria` VARCHAR(255) NOT NULL ,
        `richiediPassword` VARCHAR(55) NOT NULL ,
        `attivaRaccomandazioneProdotti` VARCHAR(55) NOT NULL ,
        `numeroProdottiRaccomandatiDaMostrare` INT(11) NOT NULL ,
        `mostraSelettoreQuantita` VARCHAR(55) NOT NULL ,
        `mostraPezziRimanenti` VARCHAR(55) NOT NULL ,
        `mostraEanPaginaProdotto` VARCHAR(55) NOT NULL ,
        `attivaAreeGeografiche` VARCHAR(55) NOT NULL ,
        `nazioniDaVisualizzare` VARCHAR(55) NOT NULL ,
        `mostraCategorie` VARCHAR(255) NOT NULL ,
        `categoriePerRiga` SMALLINT(4) NOT NULL ,
        `aspettoProdottiOfferta` VARCHAR(255) NOT NULL,
        `prodottiInOffertaPerRiga` SMALLINT(4) NOT NULL,
        `messaggioPulsanteCarrelloPaginaProdotti` VARCHAR(500) NOT NULL,
        `mostraTempoNecessarioConsegna` VARCHAR(55) NOT NULL,
        `fraseTempoNecessarioConsegna` VARCHAR(500) NOT NULL,
        `aggiungiIvaProdotti` VARCHAR(55) NOT NULL,
        `valorePredefinitoIva` INT( 11 ) NOT NULL,
        `mostraIvaPrezziNegozio` VARCHAR(55) NOT NULL,
        `mostraIvaPrezziCarrello` VARCHAR(55) NOT NULL,
        `documentoFiscale` VARCHAR(55) NOT NULL,
        `prefissoDocumentoFiscale` VARCHAR(55) NOT NULL,
        `mostraQuantitaNelRiepilogo` VARCHAR(55) NOT NULL,
        `paginaAcquistoNonEffettuato` INT( 11 ) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle impostazioni della prima riga di prodotti
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_righeProdotti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nome` VARCHAR(255) NOT NULL,
        `spazioOccupato` VARCHAR(55) DEFAULT 'col-12',
        `numeroProdotti` INT(11) NOT NULL DEFAULT 1,
        `dimensioneDivSingoloProdotto` VARCHAR(55) NOT NULL DEFAULT 'col-md-4',
        `tipoVisualizzazione` VARCHAR(55) NOT NULL DEFAULT 'tradizionale',
        `tipoProdotti` VARCHAR(55) NOT NULL DEFAULT '',
        `aspetto` VARCHAR(55) NOT NULL DEFAULT 'altezzaControllata',
        `lingua` VARCHAR(55) NOT NULL DEFAULT 'altezzaControllata',
        `etichettaPulsanteAltriProdotti` VARCHAR(255) NOT NULL DEFAULT '',
        `linkPulsanteAltriProdotti` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraTitoloComponente` VARCHAR(255) NOT NULL DEFAULT '',
        `mostraPrezzo` VARCHAR(555) NOT NULL DEFAULT 'si',
        `escludiProdottiEsauriti` VARCHAR(555) NOT NULL DEFAULT 'si',
        `categoria` INT(11) NOT NULL DEFAULT 0,
        `categorieIndicate` VARCHAR( 255 ) NOT NULL DEFAULT '',
        `escludiCategoria` INT(11) NOT NULL DEFAULT 0,
        `marca` VARCHAR(255) NOT NULL DEFAULT '',
        `escludiMarca` VARCHAR(255) NOT NULL DEFAULT '',
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    //query per creare la tabella delle impostazioni base
    $queryCreazioniTabelle[count($queryCreazioniTabelle)]  = "CREATE TABLE `geecEc_impostazioniPagamenti` (
        `id` INT( 11 ) NOT NULL AUTO_INCREMENT,
        `nomeEstrattoConto` VARCHAR(255) NOT NULL,
        `attivaPagamentoConsegna` VARCHAR(255) NOT NULL,
        `dettagliPagamentoConsegna` VARCHAR(255) NOT NULL,
        `costoPagamentoConsegna` VARCHAR(255) NOT NULL,
        `attivaPaypal` VARCHAR(55) NOT NULL,
        `attivaPaypalCartaDiCredito` VARCHAR(55) NOT NULL,
        `attivaPagamento3Rate` VARCHAR(55) NOT NULL,
        `importoMinimoPagamento3Rate` DOUBLE(8,2) NOT NULL,
        `sandboxPaypal` VARCHAR(55) NOT NULL,
        `clientIdPaypal` VARCHAR(255) NOT NULL,
        `secretPaypal` VARCHAR(255) NOT NULL,
        `attivaStripe` VARCHAR(255) NOT NULL,
        `idAccountStripe` VARCHAR(255) NOT NULL,
        `chiavePubblicaStripe` VARCHAR(255) NOT NULL,
        `chiaveSegretaStripe` VARCHAR(255) NOT NULL,
        `attivaSatispay` VARCHAR(255) NOT NULL,
        `idAccountSatispay` VARCHAR(255) NOT NULL,
        `chiavePubblicaSatispay` VARCHAR(255) NOT NULL,
        `chiaveSegretaSatispay` VARCHAR(255) NOT NULL,
        `attivaContoCorrente` VARCHAR(255) NOT NULL,
        `dettagliContoCorrente` VARCHAR(255) NOT NULL,
        `attivaPrepagata` VARCHAR(255) NOT NULL,
        `dettagliPrepagata` VARCHAR(255) NOT NULL,
        PRIMARY KEY ( `id` )
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_transazioni`( 
        `id` int(30) NOT NULL AUTO_INCREMENT, 
        `idOrdineRiferimento` int(30) NOT NULL, 
        `txn_id` VARCHAR(50) NOT NULL, 
        `payment_status` VARCHAR(50) NOT NULL, 
        `payer_email` VARCHAR(100) NOT NULL, 
        `mc_gross` VARCHAR(10) NOT NULL, 
        `payment_date` VARCHAR(100) NOT NULL,
        PRIMARY KEY (`id`), UNIQUE KEY `txn_id` (`txn_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;";

    $queryCreazioniTabelle[count($queryCreazioniTabelle)] = "CREATE TABLE `geecEc_impostazioniPaginaCarrello`( 
        `id` int(30) NOT NULL AUTO_INCREMENT, 
        `testoInAlto` TEXT(65000) NOT NULL, 
        `testoADestra` TEXT(65000) NOT NULL, 
        `testoInBasso` TEXT(65000) NOT NULL, 
        PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARACTER SET=utf8;";
    
    //inizializzo la tabella impostazioni
    $queryDiConfigurazione[count($queryDiConfigurazione)] = "INSERT INTO geecEc_impostazioni VALUES (NULL,'no','no',0,'','','destra','no','','no','no','no','0','si','no','no','no','','no',1,'altezzaControllata',3,'','no','Ricevilo entro __data__ se ordini entro le 24:00','no','0','','','nessuno','','si',0);";

    //inizializzo la tabella impostazioni
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecEc_impostazioniPaginaCarrello VALUES (NULL,'','','');";

    //creo la pagima "i miei ordini" per Geecom Admin
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','ordini.php','si','','I miei ordini','no','','','ordini','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
    //creo la pagima "dettagli ordine" per Geecom Admin
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','dettagliOrdine.php','si','','Dettagli ordine','no','','','dettagli-ordine','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
     //creo la pagima "i miei abbonamenti" per Geecom Admin
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','abbonamenti.php','si','','I miei abbonamenti','no','','','abbonamenti','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
    //creo la pagima "dettagli abbonamento" per Geecom Admin
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecAd_contenuti VALUES(NULL,'0','italiano','pagina','si','0','0','si','pubblicato','','dettagliOrdine.php','si','','Dettagli abbonamento','no','','','dettagli-abbonamento','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
    
    // aggiungo le voci di menu per Geecom Admin
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecAd_vociMenu (`id`,`idMenu`,`nome`,`idContenuto`,`vocePadre`,`icona`,`immagine`,`tipo`,`link`,`posizione`,`gruppoSpecifico`) VALUES
            (NULL,1,'I miei ordini',2,0,'','','link','index.php?alias=ordini',4,0),
            (NULL,1,'I miei abbonamenti',2,0,'','','link','index.php?alias=abbonamenti',5,0);";

    //inizializzo la tabella impostazioni pagamenti
    $queryDiConfigurazione[count($queryDiConfigurazione)]  = "INSERT INTO geecEc_impostazioniPagamenti VALUES (NULL,'','no','no',0,'no','no','no',0,'no','','','no','','','','no','','','','no','','no','');";

    //crea il componente ecommerce
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecB_componenti VALUES (NULL,'esterno','no','../template/img/componenti/icon_ecommerce.svg','Ecommerce','ecommerce','','','Geecom e-commerce 4.0','si','no')";

    //crea il componente Visualizzatore riga prodotti
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecB_componenti VALUES (NULL,'componenteDinamicoPagine','si','../template/img/componenti/icon_prodotti_negozio.svg','Prodotti dal negozio','prodottiDalNegozio','geecEc_righeProdotti','','','no','no')";
    
    //crea i componenti per il pannello laterale 
    $queryConfigurazioneTabelle[count($queryConfigurazioneTabelle)] = "INSERT INTO geecB_componenti (`id`,`tipo`,`componenteArticolo`,`icona`,`nome`,`paginaGestione`,`tabellaRiferimento`,`script`,`versione`) 
                                                                                                    VALUES (NULL,'pannelloLaterale','no','','Categorie ecommerce','','','',''),
                                                                                                           (NULL,'pannelloLaterale','no','','Prodotti più venduti','','','',''),
                                                                                                           (NULL,'pannelloLaterale','no','','Ultimi prodotti inseriti','','','',''),
                                                                                                           (NULL,'pannelloLaterale','no','','Elenco marche prodotti','','','','')";

?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <title>Installazione del componente e-commerce</title>
        <?php
            include "../{$datiGeecomCms["percorso"]}/include/cssBaseAreaAmministrativa.php";
        ?>
    </head>
    <body class="bg-primary">
        <main role="main" class="d-flex align-items-center mt-0">
            <div id="installazione" class="container">
                <div class="row">
                    <div class="col-sm-8 col-md-6 mx-auto">
                        <div class="card box-shadow-lite mb-4">
                            <div class="row">
                                <div class="col-8 col-lg-6 mx-auto">
                                    <img class="img-fluid logo mb-4" src="../template/img/geecom.svg" />
                                </div>
                                <div class="col-12">
                                    <p>Installazione del componente e-commerce di Geecom</p>       
                                    
                                    <?php 
                                        //esegue in blocco le query che creano le tabelle dle database
                                        $geecomDb->eseguiInsiemeDiQuery($queryCreazioniTabelle);

                                        //dopo aver creato tutte le tabelle stampa un messaggio
                                        echo"<p class=\"alert alert-success\">Creazione tabelle completata</p>";

                                        $geecomDb->eseguiInsiemeDiQuery($queryConfigurazioneTabelle);

                                        /***  eseguo ora una serie di query che devono essere eseguite dopo il blocco sopra ***/

                                        // creo una categoria ecommerce
                                        $queryCategoria = "INSERT INTO `geec_categorie` (`id`, `categoriaMadre`, `categoriaRiferimento`, `tipo`, `lingua`, `nome`, `alias`, `titoloPagina`, `metaDescrizione`, `cssGenerato`, `cssAggiuntivo`, `foto`, `punteggioSeo`, `tipoVisualizzazione`, `numeroArticoliPerPagina`, `posizione`, `ordinamento`, `dataCreazione`) 
                                                            VALUES (NULL, '0', '0', 'ecommerce', 'italiano', 'Categoria di prova', 'categoria-di-prova', '', '', '', '', '', 'scadente', 'classico', '12', '1', 'Data di pubblicazione, dal più nuovo', '$data'); ";
                                        $idCategoria    = $geecomDb->eseguiQueryCreazione($queryCategoria);

                                        // creo tre prodotti di esempio
                                        $queryInserimentoProdotti = "INSERT INTO `geecEc_prodotti` (`id`, `codiceProdotto`, `idFornitore`, `lingua`, `prodottoRiferimento`, `prodottoPadre`, `ean`, `nome`, `alias`, `immagine`, `template`, `pubblicato`, `usaVariazioni`, `categoria`, `disponibilita`, `prodottoInesauribile`, `prezzo`, `prezzoOfferta`, `iva`, `prezzoAcquisto`, `prezzoUnitario`, `unita`, `minimoAcquisto`, `metaDescrizione`, `descrizione`, `testoDettagli`, `marca`, `modello`, `formato`, `materiale`, `capacità`, `colore`, `larghezza`, `altezza`, `profondità`, `peso`, `pesoVolumetrico`, `acquistoOpzioneObbligatorio`, `tipoProdotto`, `numeroVisite`, `numeroVendite`, `abilitaCommenti`, `dataInserimento`) 
                                                                                                        VALUES (NULL, '','0', 'italiano', '0', '0', '', 'Prodotto di prova 1', 'prodotto-di-prova-1', 'immagini/ecommerce/prodotto-di-prova1.png', 'templateBaseProdotto.php', 'si', 'no','$idCategoria', '1', 'no', '10', '0', '0', '5', '0', '', '1','','<p>Questo &egrave; un prodotto di prova, puoi eliminarlo o modificarlo per trasformarlo nel prodotto che ti serve. Grazie per aver installato il componente e-commerce!</p>', '', '', '', '', '', '0', '', '0', '0', '0', '0', '0','no', 'fisico', '0', '0', 'no', '$data'),
                                                                                                           (NULL, '', '0','italiano', '0', '0', '', 'Prodotto di prova 2', 'prodotto-di-prova-2', 'immagini/ecommerce/prodotto-di-prova2.png', 'templateBaseProdotto.php', 'si', 'no','$idCategoria', '1', 'no', '10', '0', '0', '5', '0', '', '1','','<p>Questo &egrave; un prodotto di prova, puoi eliminarlo o modificarlo per trasformarlo nel prodotto che ti serve. Grazie per aver installato il componente e-commerce!</p>', '', '', '', '', '', '0', '', '0', '0', '0', '0', '0','no', 'fisico', '0', '0', 'no', '$data'),
                                                                                                           (NULL, '', '0','italiano', '0', '0', '', 'Prodotto di prova 3', 'prodotto-di-prova-3', 'immagini/ecommerce/prodotto-di-prova3.png', 'templateBaseProdotto.php', 'si', 'no','$idCategoria', '1', 'no', '10', '0', '0', '5', '0', '', '1','','<p>Questo &egrave; un prodotto di prova, puoi eliminarlo o modificarlo per trasformarlo nel prodotto che ti serve. Grazie per aver installato il componente e-commerce!</p>', '', '', '', '', '', '0', '', '0', '0', '0', '0', '0','no', 'fisico', '0', '0', 'no', '$data')";
                                        $geecomDb->eseguiQueryScrittura($queryInserimentoProdotti);

                                        // creo una visualizzatore prodotto
                                        $queryAggiornamentoRigheProdotto = "INSERT INTO `geecEc_righeProdotti` (`id`, `nome`, `spazioOccupato`, `numeroProdotti`, `dimensioneDivSingoloProdotto`, `tipoProdotti`, `aspetto`, `lingua`, `etichettaPulsanteAltriProdotti`, `linkPulsanteAltriProdotti`, `mostraTitoloComponente`, `mostraPrezzo`, `categoria`, `categorieIndicate`, `escludiCategoria`,`marca`,`escludiMarca`) 
                                                                                 VALUES (NULL, 'Visualizzatore 1', 'col-12', '3', 'col-md-4', 'casuali', 'altezzaControllata',  'italiano', '', '', 'no', 'si', '$idCategoria', '', '0','','')";
                                        $geecomDb->eseguiQueryScrittura($queryAggiornamentoRigheProdotto);

                                        // recupero i dati  del componente Prodotti dal negozio
                                        $datiComponenteEcommerce = $geecomDb->leggiSingolaRiga("geecB_componenti","Prodotti dal negozio","nome");

                                        // infine creo la pagina Negozio in Geecom CMS e aggiungo il componente
                                        $queryCreazionePagina = "INSERT INTO geecB_contenuti VALUES(NULL,'0','italiano','pagina','0','0','si','pubblicato','','senzaColonneLaterali.php','si','','Negozio','Negozio','si','','','negozio','','','','si',0,'','','','Geecom','$data','$data','$data','$data');";
                                        $idPaginaNegozio = $geecomDb->eseguiQueryCreazione($queryCreazionePagina);
                                        $queryAggiuntaComponenteEcommerce = "INSERT INTO `geecB_composizionePagine` (`id`, `idComponente`, `idPagina`, `tipoElemento`, `idElemento`,`posizione`, `testo`, `script`,`idSezione`,`classeSezione`) VALUES
                        (NULL, {$datiComponenteEcommerce["id"]}, $idPaginaNegozio, 'contenuto',1, 1, '','','','');";
                                        $geecomDb->eseguiQueryScrittura($queryAggiuntaComponenteEcommerce);

                                        // inserisco la posizione del negozio
                                        $queryAggiuntaVoceMenuNegozio = "INSERT INTO geecB_vociMenu (`id`,`idMenu`,`idContenuto`,`vocePadre`,`mostraNomiColonne`,`testoAssociato`,`nome`,`icona`,`immagine`,`tipo`,`link`,`posizione`) VALUES
                                                                            (NULL,1,$idPaginaNegozio,0,'','','Negozio','','','link','index.php?alias=negozio',2),
                                                                            (NULL,1,0,0,'','','Carrello','fas fa-shopping-cart','','linkCarrello','carrello.php',5)";
                                        $geecomDb->eseguiQueryScrittura($queryAggiuntaVoceMenuNegozio);

                                        // inserisco le spedizioni di base
                                        $queryCreazioneSpedizioni = "INSERT INTO `geecEc_metodiSpedizione` (`id`, `nome`, `disponibile`, `categoria`, `descrizione`, `giorniNecessari`, `giorniInCuiSiSpedisce`, `orarioLimite`, `costo`, `costoZoneDisagiate`, `importoMinimoCarrello`, `areaGeografica`, `dataCreazione`) 
                                                                            VALUES (NULL, 'Spedizione gratuita', 'no', '', 'Spedizione gratuita', 2, 'Lunedi - Venerdi', '00:00', '0', '0', '0', '0', '2021-10-18'),
                                                                                   (NULL, 'Corriere espresso', 'si', '', 'Spedizione in 2 - 3 giorni lavorativi', 2, 'Lunedi - Venerdi', '00:00', '7', '7', '0', '0', '2021-10-18');";
                                        $geecomDb->eseguiQueryScrittura($queryCreazioneSpedizioni);
                                        
                                        // attivo le API di Geecom Admin
                                        $queryAggiornamentoApiAdmin = "UPDATE geecAd_impostazioni SET attivaApi='si' WHERE id=1";
                                        $geecomDb->eseguiQueryScrittura($queryAggiornamentoApiAdmin);
					    
                                        // aggiungo nelle inclusioni lo script dell'ecommerce 
                                        $geecomDb->eseguiQueryScrittura("UPDATE geecB_inclusioni SET fineBody = '{$inclusioniGlobale["fineBody"]} <script src=\"js/ecommerce/ecommerce.js\"></script>'");
					  
                                        //dopo aver terminato l'inizializzazione di alcune tabelle stampa un messaggio
                                        echo"<p class=\"alert alert-success\">Configurazione eseguita</p>";

                                        echo"<p class=\"alert alert-success\">Installazione terminata!</p>";
                                        
                                    ?>

                                    <a href="<?php echo GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiGeecomCms); ?>" class="btn btn-success btn-block">Vai all'area amministrativa</a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div><!-- /container -->
        </main>
        
        <?php
            include "../{$datiGeecomCms["percorso"]}/include/footer.php";
        ?>
        
        <!-- Optional JavaScript -->
	<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
	<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.1/js/bootstrap.min.js" integrity="sha384-smHYKdLADwkXOn1EmN1qk/HfnUcbVRZyYmZ4qpPea6sjB/pTJ0euyQp0Mk8ck+5T" crossorigin="anonymous"></script>  
	
	<!-- Tooltips e Popover -->
	<script>
            $(function () {
              $('[data-toggle="tooltip"]').tooltip()
            }) 
	</script>
	  
  </body>
</html>
